% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{sort.clustering}
\alias{sort.clustering}
\title{Returns the clustering result sorted by a set of metrics.}
\usage{
\method{sort}{clustering}(x, decreasing = TRUE, ...)
}
\arguments{
\item{x}{It's an \code{clustering} object.}

\item{decreasing}{A logical indicating if the sort should be increasing or
decreasing. By default, decreasing.}

\item{...}{Additional parameters as "by", a String with the name of the
evaluation measure to order by. Valid values are: \code{Algorithm, Distance,
Clusters, Data, Var, Time, Entropy, Variation_information,
Precision, Recall, F_measure, Fowlkes_mallows_index, Connectivity, Dunn,
Silhouette and TimeAtt}.}
}
\value{
Another \code{clustering} object with the evaluation measures sorted
}
\description{
This function receives a clustering object and sorts the
columns by parameter. By default it performs sorting by the algorithm field.
}
\details{
The additional argument in "..." is the 'by' argument, which is a
array with the name of the evaluation measure to order by. Valid value are:
\code{Algorithm, Distance, Clusters, Data, Var, Time, Entropy,
Variation_information, Precision, Recall, F_measure, Fowlkes_mallows_index,
Connectivity, Dunn, Silhouette, TimeAtt}.
}
\examples{

library(Clustering)

result <-
clustering(df = cluster::agriculture,min = 4, max = 4,algorithm='gmm',
metrics='Recall')

sort(result, FALSE, 'Recall')

}
