% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B1MODImatrizP.R
\name{B1MODImatrizP}
\alias{B1MODImatrizP}
\title{Ridge regression matrix}
\usage{
B1MODImatrizP(Tt, especieII, especie, E, EspecieMaxima)
}
\arguments{
\item{Tt}{Number of time points available}

\item{especieII}{Number. The number of the row in which the bacteria that we want to use is placed in the matrix \code{especie}.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{E}{Number of bacteria available}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}. This is the bacteria that is going to be at the denominator of the balance and at the denominator of the alr transformation.}
}
\value{
Returns a matrix. The first column contain the number 1 repeated \code{Tt} times. The second column contains
the alr transformation of the \code{especieII} in all time points. The third column
contains the balance (whose numerator has all the bacteria except \code{especieII} and \code{EspecieMaxima} and the denominator
contains the \code{EspecieMaxima}) in all time points.
}
\description{
Defining the part of the ridge regression matrix  that  carries the information of the bacteria \code{especieII}.
}
\examples{


Tt=2
especie1=cbind(c(0.5,0.3,0.2), c(0.1,0.3,0.6))
especieII=1
E=3
EspecieMaxima=3

B1MODImatrizP(Tt, especieII,especie1, E, EspecieMaxima)

}
