% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QualityControl.R
\name{QualityControl}
\alias{QualityControl}
\title{Analysing the quality of the estimation}
\usage{
QualityControl(matrixData, matrixExpected, names.especie)
}
\arguments{
\item{matrixData}{Matrix that contains at row i the bacterial taxa of bacteria i at the time points that we want take into account to calculate the quality control values.}

\item{matrixExpected}{Matrix that contains at row i the expected value of the bacterial taxa i at the time points that we want take into account to calculate the quality control values. The bacteria must be placed in the same order than in \code{matrixData}}

\item{names.especie}{Vector with the names of the bacteria in the same order that are placed in the \code{matrixData} matrix.}
}
\value{
Returns a data.frame.
}
\description{
This function calculates the  root-mean-square deviation (RMSD), the Nash Sutchiffe Coefficient, the residual sum of squares (RSS) and the mean absolute percentage error (MAPE) for the matrices introduces. This function also calculates the mean of the RMSD, the mean of the Nash Sutchiffe Coefficient  and the mean of the RSS.
}
\examples{


names.especie=c("Bact1", "Bact2", "Bact3")
matrixExpected=matrix(c(1:9),3,3)
matrixData=matrixExpected+0.1

QualityControl(matrixData, matrixExpected,names.especie)


}
