% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRF.r
\name{checkRF}
\alias{checkRF}
\title{Numerical and visual check of generated random fields}
\usage{
checkRF(RF, lags = 30, nfields = 49, method = "stat")
}
\arguments{
\item{RF}{output of \code{\link{generateRF}}}

\item{lags}{number of lags of empirical STCF to be considered in the
graphical output (default set to 30)}

\item{nfields}{number of fields to be used in the numerical and graphical
output (default set to 49). As the plots are arranged in a matrix with nrows as close as possible to ncol, we suggest using values such as 3x3, 3x4, 7x8, etc.}

\item{method}{report method - 'stat' for basic statistical report,
'statplot'for graphical check of lagged SCS, target STCS, and marginal
distribution, 'field' for plotting a matrix of the first 'nfields',
and 'movie' to save the first 'nfields' as a GIF file named "movieRF.gif"
in the current working directory}
}
\description{
Compares generated random fields sample statistics with the theoretically
expected values (similar to checkTS). It also returns graphical output for
visual check
}
\examples{
## The example below refers to the fitting and simulation of 10 random fields
## of size 10x10 with AR(1) temporal correlation. As the fitting algorithm has
## O((mxm)^3) complexity for a mxm field, this setting allows for quick fitting
## and simulation (short CPU time). However, for a more effective visualization
## and reliable performance assessment, we suggest to generate a larger number
## of fields (e.g. 100 or more) of size about 30X30. This setting needs more
## CPU time but enables more effective comparison of theoretical and
## empirical statistics. Sizes larger than about 50x50 can be unpractical
##  on standard machines.

fit <- fitVAR(
  spacepoints = 10,
  p = 1,
  margdist ='burrXII',
  margarg = list(scale = 3, shape1 = .9, shape2 = .2),
  p0 = 0.8,
  stcsid = "clayton",
  stcsarg = list(scfid = "weibull", tcfid = "weibull",
                 copulaarg = 2,
                 scfarg = list(scale = 20, shape = 0.7),
                tcfarg = list(scale = 1.1, shape = 0.8))
)

sim <- generateRF(n = 12,
                    STmodel = fit)
checkRF(RF = sim,
          lags = 10,
          nfields = 12)


}
