% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoastlineFractalDimension.R
\name{FD}
\alias{FD}
\title{CoastlineFD}
\usage{
FD(DinputPath, BinputPath, netPath, outputPath, year, r, pearsonValue, showFlag)
}
\arguments{
\item{DinputPath}{All density shoreline files path}

\item{BinputPath}{All origin shoreline files path}

\item{netPath}{All fishnet files path}

\item{outputPath}{FD results will be exported here}

\item{year}{R vector object, which represent your study time}

\item{r}{R vector object, which represent your study scale}

\item{pearsonValue}{The Pearson coefficient of your input data}

\item{showFlag}{Drawing Function's result}
}
\value{
An .xlsx file containing the results of the fractal dimension calculation, and a fractal dimension graph
}
\description{
Calculate the Coastline Fractal Dimension
}
\examples{
DinputPath = list.files(system.file('extdata', package = 'CoastlineFD'),full.names = TRUE)[2]
BinputPath = list.files(system.file('extdata', package = 'CoastlineFD'),full.names = TRUE)[1]
netPath = list.files(system.file('extdata', package = 'CoastlineFD'),full.names = TRUE)[3]
outputPath = paste0(system.file('extdata', package = 'CoastlineFD'), "/FD1985_1986.xlsx")

FD(
  DinputPath,
  BinputPath,
  netPath,
  outputPath,
  c(1985:1986),
  c(300, 600, 900, 1000, 1050, 1100),
  0.00,
  TRUE
)

}
