% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hedgesgp.R
\name{Hedgesgp}
\alias{Hedgesgp}
\title{The unbiased Hedges' standardized mean difference.}
\usage{
Hedgesgp(statistics, design)
}
\arguments{
\item{statistics}{a list of pre-computed statistics. The statistics to provide
depend on the design:
- for "between": \code{m1}, \code{m2} the means of the two groups,
\code{s1}, \code{s2} the standard deviation of the two groups, and
\code{n1}, \code{n2}, the sample sizes of the two groups;
- for "within": \code{m1}, \code{m2}, \code{s1}, \code{s2}, \code{n}, and
\code{r} or \code{rho} the correlation between the measure;
- for "single": \code{m}, \code{s}, \code{n} and \code{m0} the reference
mean from which \code{m} is standardized).}

\item{design}{the design of the measures (\code{"within"}, \code{"between"}, or \code{"single"});}
}
\value{
The unbiased Cohen's $d_p$ statistic, commonly called a Hedges' $g_p$.
The return value is internally a dpObject which can be
displayed with print, explain or summary/summarize.
}
\description{
\code{Hedgesgp()} computes the unbiased Cohen's d (noted $g_p$) in either within-subject,
between-subject design and single-group design. See
\insertCite{h81,gc18;textual}{CohensdpLibrary}.
}
\details{
This function returns the Cohen's d_p statistics corrected for bias but no confidence
interval as this estimate is not used to build such interval.
This function uses r when rho is unknown.
}
\examples{

# example in which the means are 114 vs. 101 with sDs of 14.3 and 12.5 respectively 
Hedgesgp( statistics = list( m1= 101, m2= 114, s1= 12.5, s2= 14.3, n1= 12, n2= 12 ), 
          design     = "between")

# example in a repeated-measure design
Hedgesgp( statistics = list( m1= 101, m2= 114, s1= 12.5, s2= 14.3, n= 12, rho= 0.53 ), 
          design     = "within")

# example with a single-group design where mu is a population parameter
Hedgesgp( statistics = list( m = 101, m0 = 114, s = 12.5, n = 10 ), 
          design     = "single")

# The results can be displayed in three modes
res <- Hedgesgp( statistics = list( m = 101, m0 = 114, s = 12.5, n = 10 ), 
                 design     = "single")

# a raw result of the Cohen's d_p and its confidence interval
res              

# a human-readable output
summarize( res ) 

# ... and a human-readable ouptut with additional explanations 
explain( res )   
                 

}
\references{
\insertAllCited{}
}
