% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unionCohorts.R
\name{unionCohorts}
\alias{unionCohorts}
\title{Generate cohort from the union of different cohorts}
\usage{
unionCohorts(
  cohort,
  cohortId = NULL,
  gap = 0,
  cohortName = NULL,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to include. If NULL all cohorts will be
considered. Cohorts not included will be removed from the cohort set.}

\item{gap}{Number of days between two subsequent cohort entries of a subject
that will be merged in a single cohort entry}

\item{cohortName}{Name of the returned cohort. If NULL, the cohort name will
be created by collapsing the individual cohort names, separated by "_".}

\item{name}{Name of the new cohort table.}
}
\value{
A cohort table.
}
\description{
Generate cohort from the union of different cohorts
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort2 <- cdm$cohort2 |> unionCohorts()
settings(cdm$cohort2)

}
}
