% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortStats.R
\name{getCohortStats}
\alias{getCohortStats}
\title{Get Cohort Inclusion Stats Table Data}
\usage{
getCohortStats(
  connectionDetails,
  connection = NULL,
  cohortDatabaseSchema,
  databaseId = NULL,
  snakeCaseToCamelCase = TRUE,
  outputTables = c("cohortInclusionTable", "cohortInclusionResultTable",
    "cohortInclusionStatsTable", "cohortInclusionStatsTable", "cohortSummaryStatsTable",
    "cohortCensorStatsTable"),
  cohortTableNames = getCohortTableNames()
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{databaseId}{Optional - when specified, the databaseId will be added
to the exported results}

\item{snakeCaseToCamelCase}{Convert column names from snake case to camel case.}

\item{outputTables}{Character vector. One or more of "cohortInclusionTable", "cohortInclusionResultTable",
"cohortInclusionStatsTable", "cohortInclusionStatsTable", "cohortSummaryStatsTable"
or "cohortCensorStatsTable". Output is limited to these tables. Cannot export, for,
example, the cohort table. Defaults to all stats tables.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}
}
\description{
This function returns a data frame of the data in the Cohort Inclusion Tables.
Results are organized in to a list with 5 different data frames:
\itemize{
\item cohortInclusionTable
\item cohortInclusionResultTable
\item cohortInclusionStatsTable
\item cohortSummaryStatsTable
\item cohortCensorStatsTable
}

These can be optionally specified with the \code{outputTables}.
See \code{exportCohortStatsTables} function for saving data to csv.
}
