% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{availableSurvivalGrouping}
\alias{availableSurvivalGrouping}
\title{Variables that can be used for faceting and colouring survival plots}
\usage{
availableSurvivalGrouping(result, varying = FALSE)
}
\arguments{
\item{result}{Survival results}

\item{varying}{If FALSE (default), only variables with non-unique values will be
returned, otherwise all available variables will be returned.}
}
\description{
Variables that can be used for faceting and colouring survival plots
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(cdm,
                                    targetCohortTable = "mgus_diagnosis",
                                    outcomeCohortTable = "death_cohort")
availableSurvivalGrouping(surv)
}
}
