% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.g.model.R
\name{a.g.model}
\alias{a.g.model}
\title{Generates a random tree}
\usage{
a.g.model(n, alpha, gamma)
}
\arguments{
\item{n}{the number of leaves in the tree.}

\item{alpha}{parametrer of the alpha-gamma model, between 0 and 1.}

\item{gamma}{parametrer of the alpha-gamma model, between 0 and alpha.}
}
\value{
An igraph object that represents the generated phylogenetic tree.
}
\description{
Given alpha, gamma and the number of leaves n, generates a random phylogenetic tree between all trees with n leaves following the alpha-gamma model.
}
\examples{
 

# A phylogenetic tree with 10 leaves and parameters alpha=0.8 and gamma=0.1
\donttest{tree = a.g.model(10,0.8,0.1)}
\donttest{plot(tree,layout=layout.reingold.tilford(tree,root=which(degree(tree,mode="in")==0)))}
 
}
\references{
B. Chen, D. Ford, M. Winkel, A new family of Markov branching trees: the alpha-gamma model. \emph{Electr. J. Probab}. \bold{14} (2009), 400-430.
}
\author{
Lucia Rotger
}
