% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Colombia_info.R
\name{get_Colombia_info}
\alias{get_Colombia_info}
\title{Get Information About Colombia}
\usage{
get_Colombia_info()
}
\value{
A `data.frame` with the following columns:
  \itemize{
    \item \code{name}: Name of the country.
    \item \code{surface}: The surface area of the country in square kilometers.
    \item \code{population}: The population of the country.
    \item \code{timeZone}: The time zone of the country.
    \item \code{currency}: The currency used in the country.
    \item \code{currencySymbol}: The currency symbol.
    \item \code{region}: The region of the country in the world.
  }
}
\description{
This function makes an API call https://api-colombia.com/api/v1/Country/Colombia
to retrieve information about Colombia, such as its name, surface area, population, time zone, currency, and region.
It processes the API response and returns the data in a structured data.frame.
}
\details{
The function sends a GET request to the API at
  \url{https://api-colombia.com/api/v1/Country/Colombia}. If the API returns
  a successful response (status code 200), the data is parsed and returned.
  If the response is unsuccessful or the structure is not as expected,
  the function will return \code{NULL}.
}
\note{
Ensure you have an active internet connection to access the API. If the API structure changes
or the API becomes unavailable, the function may need modifications.

This function relies on the following packages: \code{httr} and \code{jsonlite}.
These packages are used for making HTTP requests and processing JSON responses, respectively.
}
\examples{
\dontrun{
  # Call the function to get Colombia information
  colombia_info <- get_Colombia_info()

  # Print the result
  print(colombia_info)
}

}
