% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pcomp}
\alias{pcomp}
\title{Conway-Maxwell-Poisson Cumulative Density Function}
\usage{
pcomp(q, lam, nu, sumTo = 100L, lowerTail = TRUE, logP = FALSE)
}
\arguments{
\item{q}{an integer vector where the CDF is to be calculated. If the input is not an
integer, it will be coerced to be an integer.}

\item{lam}{a double vector of the parameter \eqn{\lambda}.}

\item{nu}{a double vector of the parameter \eqn{\nu}.}

\item{sumTo}{an integer for the summation term in the density (default 100)}

\item{lowerTail}{a boolean for if P(Y<=q) should be returned
(default \code{TRUE}), otherwise, P(Y>q) is returned.}

\item{logP}{a boolean for if the log of the probability should be given (default \code{FALSE})}
}
\value{
The value of the CDF (or 1-CDF if \code{lowerTail = FALSE}) or log of this value if
\code{logP = TRUE}. Input vectors are recycled to be same length.
}
\description{
The CDF of the Conway-Maxwell-Poisson distribution with parameters
\code{lam} and \code{nu} at point \code{q}.
}
\details{
See \code{\link{dcomp}} for details of the PDF.
}
\examples{
pcomp(1:10, 1.5, 1.2)
}
\author{
Jeffrey Pollock <jeffpollock9@gmail.com>
}

