% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIC.R
\name{GIC.compCL}
\alias{GIC.compCL}
\title{Compute information crieteria for the \code{compCL} model.}
\usage{
GIC.compCL(y, Z, Zc = NULL, intercept = FALSE, lam = NULL, ...)
}
\arguments{
\item{y}{a response vector with length n.}

\item{Z}{a \eqn{n \times p}{n*p} design matrix of compositional data or categorical data.
If \code{Z} is categorical data, i.e., row-sums of \code{Z} differ from 1, the program automatically transforms
\code{Z} into compositional data by dividing each row by its sum.
\code{Z} could NOT include entry of 0's.}

\item{Zc}{a \eqn{n*p_c} design matrix of control variables (not penalized). Default is \code{NULL}.}

\item{intercept}{Boolean, specifying whether to include an intercept.
Default is \code{FALSE}.}

\item{lam}{a user supplied lambda sequence.
If \code{lam} is provided as a scaler and \code{nlam}\eqn{>1}, \code{lam} sequence is created starting from
\code{lam}. To run a single value of \code{lam}, set \code{nlam}\eqn{=1}.
The program will sort user-defined \code{lambda} sequence in decreasing order.}

\item{\dots}{other arguments that can be passed to compCL.}
}
\value{
an object of S3 class \code{GIC.compCL} is returned, which is a list:
\item{compCL.fit}{a fitted \code{\link{compCL}} object.}
\item{lam}{the sequence of \code{lam}.}
\item{GIC}{a vector of GIC value(s).}
\item{lam.min}{the \code{lam} value that minimizes \code{GIC}(\eqn{\lambda}).}
}
\description{
Tune the penalty parameter code{lam} in the \code{compCGL} model by GIC, BIC, or AIC. This
function calculates the GIC, BIC, or AIC curve and returns the optimal value of
\code{lam}.
}
\details{
The model estimation is conducted through minimizing the following criterion:
\deqn{\frac{1}{2n}\|y-Z\beta\|_2^2 + \lambda\|\beta\|_1, s.t. \sum_{j=1}^{p} \beta_j = 0.}
The GIC is defined as:
\deqn{GIC(\lambda) = \log{\hat{\sigma}^2(\lambda)} +
(s(\lambda) -1) \log{(max(p, n))} * \log{(\log{n})} / n,}
where \eqn{\hat{\sigma}^2(\lambda) = \|y - Z\hat{\beta}(\lambda)\|_{2}^{2}/n},
\eqn{\hat{\beta}(\lambda)} is the regularized estimator,
and \eqn{s(\lambda)} is the number of nonzero coefficients in \eqn{\hat{\beta}(\lambda)}.
Because of the zero-sum constraint, the effective number of free parameters is
\eqn{s(\lambda) - 1} for \eqn{s(\lambda) \ge 2}.
The optimal \eqn{\lambda} is selected by minimizing \code{GIC}(\eqn{\lambda}).
}
\examples{
p = 30
n = 50
beta = c(1, -0.8, 0.6, 0, 0, -1.5, -0.5, 1.2)
beta = c(beta, rep(0, times = p - length(beta)))
Comp_data = comp_Model(n = n, p = p, beta = beta, intercept = FALSE)
GICm1 <- GIC.compCL(y = Comp_data$y, Z = Comp_data$X.comp,
                    Zc = Comp_data$Zc, intercept = Comp_data$intercept)
coef(GICm1)
plot(GICm1)
test_data = comp_Model(n = 100, p = p, beta = Comp_data$beta, intercept = FALSE)
y_hat = predict(GICm1, Znew = test_data$X.comp, Zcnew = test_data$Zc)
plot(test_data$y, y_hat, xlab = "Observed value", ylab = "Predicted value")
abline(a = 0, b = 1, col = "red")


}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979

Fan, Y., and Tang, C. Y. (2013) \emph{Tuning parameter selection in high
dimensional penalized likelihood},
\href{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/rssb.12001}{https://rss.onlinelibrary.wiley.com/doi/abs/10.1111/rssb.12001}
\emph{Journal of the Royal Statistical Society. Series B} \strong{75} 531-552
}
\seealso{
\code{\link{compCL}} and \code{\link{cv.compCL}},
and \code{\link[=coef.GIC.compCL]{coef}}, \code{\link[=predict.GIC.compCL]{predict}} and
\code{\link[=plot.GIC.compCL]{plot}} methods for \code{"GIC.compCL"} object.
}
