% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EquallyWeightedPortfolio.R
\name{EquallyWeightedPortfolio}
\alias{EquallyWeightedPortfolio}
\title{Equally weighted portfolio}
\usage{
EquallyWeightedPortfolio(
  x,
  method = c("cumsum", "cumprod"),
  statistics = c("Fisher", "Bartlett", "Fligner-Killeen", "Levene", "Brown-Forsythe"),
  digit = 2
)
}
\arguments{
\item{x}{zoo return matrix (in percentage)}

\item{method}{Cumulative sum or cumulative product}

\item{statistics}{Hedging effectiveness statistic}

\item{digit}{Number of decimal places}
}
\value{
Get portfolio weights
}
\description{
This function calculates the equality weighted portfolio
}
\examples{
data("g2020")
mcp = EquallyWeightedPortfolio(g2020, method="cumsum", statistics="Fisher")
mcp$TABLE
}
\references{
Ederington, L. H. (1979). The hedging performance of the new futures markets. The Journal of Finance, 34(1), 157-170.

Antonakakis, N., Cunado, J., Filis, G., Gabauer, D., & de Gracia, F. P. (2020). Oil and asset classes implied volatilities: Investment strategies and hedging effectiveness. Energy Economics, 91, 104762.
}
\author{
David Gabauer
}
