% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreConcept.R
\name{belongsToCore}
\alias{belongsToCore}
\title{Check if point is core element}
\usage{
belongsToCore(x, v)
}
\arguments{
\item{x}{numeric vector containing allocations for each player}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} for a point belonging to the core and \code{FALSE} otherwise
}
\description{
belongsToCore checks if a given point is in the core
}
\examples{
library(CoopGame)
v = c(0,1,2,3,4,5,6)
belongsToCore(c(1,2,3),v)
}
\references{
Gillies D.B. (1953)  \emph{Some Theorems on n-person Games}, Ph.D. Thesis, Princeton University Press.

Aumann R.J. (1961) "The core of a cooperative game without side payments", Transactions of the American Mathematical Society 98(3), pp. 539--552

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 27--49

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 686--747

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 257--275
}
\author{
Franz Mueller

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
