% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxPlot.R
\name{BoxPlot}
\alias{BoxPlot}
\title{Boxplot with confidence interval and ANOVA on the plot.}
\usage{
BoxPlot(num, grp = NULL, data = NULL, AnoVa = TRUE, risk = 0.05,
  lang = c("en", "fr"), ...)
}
\arguments{
\item{num}{a numeric vector to plot boxplot(num~grp). Represents the value that will be compared between the groups.}

\item{grp}{a qualitative vector (factor) to plot boxplot(num~grp). Represents the groups we will compare.}

\item{data}{a data.frame (or list) from which the variables in formula should be taken.}

\item{AnoVa}{boolean to compute or not anova (when multiple groups) to see if they differ in mean.If false the Kruskal-Wallis Rank Sum test is computed instead.}

\item{risk}{the risk value used for confidence intervals}

\item{lang}{lingustic parameter to specify the language of the legend}

\item{...}{Other graphical parameters}
}
\description{
classical boxplot function improved with integrated confidence level on the mean for each group ploted on the graph and also ANOVA with p-value and its interpretation given in the legend.
}
\examples{
    \dontrun{
require(CorReg)
repart=c(20,40,40)
X=data.frame(num=c(rnorm(repart[1],10,1),rnorm(repart[2],11,1),rnorm(repart[3],10,1)),
grp=c(rep("A",times=repart[1]),rep("B",times=repart[2]),rep("C",times=repart[3])))


BoxPlot(X$num,X$grp,data=X,ylab="num",main="boxplot with confidence intervals")
#Confidence interval in red with mean in blue.

}
}
