% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWeibullgamma.R
\name{dWeibullgammaCount_loglik}
\alias{dWeibullgammaCount_loglik}
\title{wrapper to the weibull-gamma count log-likelihood}
\usage{
dWeibullgammaCount_loglik(x, shape, shapeGam, scaleGam, Xcovar = NULL,
  beta = NULL, method = c("series_acc", "series_mat"), time = 1,
  na.rm = TRUE, series_terms = 50, series_acc_niter = 300,
  series_acc_eps = 1e-10, weights = NULL)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{shape}{numeric, shape parameter.}

\item{shapeGam}{numeric shape and scale parameters of the gamma
heterogeity function.}

\item{scaleGam}{numeric shape and scale parameters of the gamma
heterogeity function.}

\item{Xcovar}{matrix the regressor values. Should have the same number
of rows as \code{length(x)}. If NULL, no regression will be considered.}

\item{beta}{numeric regression coefficients. If NULL, no regression
will be considered.}

\item{method}{character one of the available methods. See details.}

\item{time}{double, length of the observation window (defaults to 1).}

\item{na.rm}{logical if TRUE, the \code{NA} (produced by taking the log of
very small probabilities) will be replaced by the smallest allowed probaility;
default = \code{TRUE}}

\item{series_terms}{numeric number of terms in the series expansion.}

\item{series_acc_niter}{numeric number of iteration in the
Euler-van Wijngaarden algorithm.}

\item{series_acc_eps}{numeric tolerance of convergence in the
Euler-van Wijngaarden algorithm.}

\item{weights}{numeric vector of weights to apply. If \code{NULL}, one will
be applied.}
}
\value{
double log-likelihood of the count process
}
\description{
wrapper to the univariate weibull-gamma log-likelihood
}

