% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--analysis_tools--DHS_methods--regression_algo.R
\name{buildRegressionEstimateTable}
\alias{buildRegressionEstimateTable}
\title{Run DHS analysis at a top level}
\usage{
buildRegressionEstimateTable(
  DataMod,
  RunOn = "sars_cov2_adj_load_log10",
  SplitOn = "site",
  DaysRegressed = 5,
  verbose = FALSE,
  PSigTest = TRUE
)
}
\arguments{
\item{DataMod}{The DF containing the col RunOn + date}

\item{RunOn}{The col names of the values we wish to run}

\item{SplitOn}{A category to separate to create independent TS data}

\item{DaysRegressed}{number of days used in each regression}

\item{verbose}{Bool on whether it should print out what group it is on}

\item{PSigTest}{When categorizing if it should reject high pVals}
}
\value{
A DF with the associated Date and DHS analysis
}
\description{
buildRegressionEstimateTable is used to create a data frame that has the
predicted categorization as laid out by the DHS. For each RunOn var supplied
It uses the var to create a 5 day lm fit and uses the percent change to bin
the results into 5 categories, "major decrease", "moderate decrease",
"fluctuating", "moderate increase", and "major increase".
If the model P-value if over .3 the category is replaced with "no change"
}
\examples{
library(dplyr)
data(Example_data, package = "Covid19Wastewater")
Example_data <- Example_data[Example_data$site == 'Janesville',]
Example_log_data <- mutate(Example_data, log_geo_mean = log10(geo_mean + 1))
head(buildRegressionEstimateTable(Example_log_data, SplitOn = "site", 
                                           RunOn = "log_geo_mean"))
}
