% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get.kappa}
\alias{get.kappa}
\title{Compute sensitivity value}
\usage{
get.kappa(d, alpha = 0.05, mm = c(2, 2, 2))
}
\arguments{
\item{d}{a vector of treatment-minus-control differences}

\item{alpha}{significance level}

\item{mm}{test statistic, either a vector of length 3 or a matrix of three rows where each column corresponds to a U-statistic. Default is the (approximate) Wilcoxon's signed rank test.}
}
\value{
sensitivity value, i.e. the kappa value such that the p-value becomes just insignificant. If \code{mm} is a matrix, then return a vector of sensitivity values corresponding to each column of \code{mm}.
}
\description{
Compute sensitivity value
}
\details{
The alternative direction is the the center of \code{d} is greater than 0.
}
\author{
Qingyuan Zhao
}
\references{
Qingyuan Zhao. On sensitivity value of pair-matched observational studies. arXiv 1702.03442, \url{https://arxiv.org/abs/1702.03442}.
}

