% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_records.R
\name{map_records}
\alias{map_records}
\title{Map VA records to coding algorithm.}
\usage{
map_records(records, mapping, csv_outfile = "")
}
\arguments{
\item{records}{A dataframe, obtained from reading an ODKBriefcase
export of records collected with the WHO questionnaire.}

\item{mapping}{Name of an algorithm to map to (one of "interva4", "insilicova", or "tariff2""),
or name of a mapping file.}

\item{csv_outfile}{Path to a file to write transformed data to.
Defaults to empty string, in which case no file is written.}
}
\value{
A dataframe, with the VA records mapped to the variables required
  by a coding algorithm, as specified in the mapping file.
}
\description{
\code{map_records} transform data collected with the WHO VA instrument
  to serve different alogrithms for coding cause of death.
}
\examples{

\dontrun{
record_f_name <- system.file('sample', 'who_va_output.csv', package = 'CrossVA')
records <- read.csv(record_f_name)
output_data <- map_records(records, 'insilicova')
output_f_name <- "output_for_insilicova.csv"
write.table(
output_data,
output_f_name,
row.names = FALSE,
na = "",
qmethod = "escape",
sep = ","
)
mapping_file <- system.file('mapping', 'interva4_mapping.txt', package = 'CrossVA')
output_data <- map_records(records, mapping_file)
output_f_name <- "output_for_interva4.csv"
write.table(
output_data,
output_f_name,
row.names = FALSE,
na = "",
qmethod = "escape",
sep = ","
)
}

}
