% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odk2openVA_v151.R
\name{odk2openVA_v151}
\alias{odk2openVA_v151}
\title{Map VA records (version 1.5.1) to InterVA5 & InSilico (with option data.type = "WHO2016").}
\usage{
odk2openVA_v151(odk, id_col = "meta.instanceID")
}
\arguments{
\item{odk}{A dataframe, obtained from reading an ODK Briefcase
export of records collected with the WHO questionnaire.}

\item{id_col}{A character string of the column name (in odk) with the
unique ID for each death.}
}
\description{
\code{odk2openVA_v151} transforms data collected with the 2016 WHO VA
instrument (version 1.5.1) to serve as the input for the InterVA5
and InSilicoVA alogrithms for coding cause of death.  Note: versions
1.5.2 and 1.5.2 do not include changes that require modification for
the data preparation, so the code for version 1.5.1 should also work
for these later two versions.
}
\examples{
\dontrun{
record_f_name <- system.file("sample", "who151_odk_export.csv", package = "CrossVA")
records <- read.csv(record_f_name, stringsAsFactors = FALSE)
output <- odk2openVA_v151(records)
}

}
