/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.archive;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.mutoss.config.Configuration;
import org.mutoss.gui.Design;
import org.mutoss.gui.archive.DesignArchive;
import org.mutoss.gui.archive.SaveException;
import org.mutoss.gui.dialogs.ConfirmArchivePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignArchiveControl {
    DesignArchive searchResults;
    DesignArchive defaultEntered;
    public static final String SEARCH = "search";
    public static final String ENTERED = "entered";
    public boolean designsChanged = false;
    List<DesignArchive> archiveLibrary = new Vector<DesignArchive>();
    String searchResultsFile = null;
    String defaultEnteredFile = null;

    public DesignArchiveControl() {
        String savedir = Configuration.getInstance().getGeneralConfig().getSaveDir();
        if (!savedir.equals("NOT_SET")) {
            this.searchResultsFile = savedir + "/" + "searchResults.RData";
            this.defaultEnteredFile = savedir + "/" + "enteredDesigns.RData";
        }
        this.searchResults = new DesignArchive(this.searchResultsFile);
        this.defaultEntered = new DesignArchive(this.defaultEnteredFile);
    }

    public void save(JFrame frame) {
        String savedir = Configuration.getInstance().getGeneralConfig().getSaveDir();
        if (savedir.equals("NOT_SET") || Configuration.getInstance().getGeneralConfig().askForSaveDir()) {
            new ConfirmArchivePath(frame);
            Configuration.getInstance().getGeneralConfig().setAskForSaveDir(false);
        }
        if (!(savedir = Configuration.getInstance().getGeneralConfig().getSaveDir()).equals("NOT_SET")) {
            try {
                this.searchResults.file = new File(savedir + "/" + "searchResults.RData");
                this.defaultEntered.file = new File(savedir + "/" + "enteredDesigns.RData");
                this.searchResults.save();
                this.defaultEntered.save();
                for (DesignArchive da : this.archiveLibrary) {
                    da.save();
                }
                this.designsChanged = false;
            }
            catch (SaveException e) {
                e.printStackTrace();
            }
        }
    }

    public void addSearchResult(Design design) {
        this.searchResults.addDesign(design);
        this.designsChanged = true;
    }

    public void addEnteredDesign(Design design) {
        this.defaultEntered.addDesign(design);
        this.designsChanged = true;
    }

    public List<Design> getDesigns(int t, int p, int s1, int s2, String string) {
        DesignArchive da = null;
        Vector<Design> result = new Vector<Design>();
        if (string.equals(SEARCH)) {
            da = this.searchResults;
        } else if (string.equals(ENTERED)) {
            da = this.defaultEntered;
        }
        for (Design d : da.designs) {
            if (d.t != t || d.p != p || d.s < s1 || d.s > s2) continue;
            result.add(d);
        }
        return result;
    }
}

