% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuinlanAttributes.R, R/makeDataFile.R,
%   R/makeNamesFile.R
\name{QuinlanAttributes}
\alias{QuinlanAttributes}
\alias{QuinlanAttributes.numeric}
\alias{QuinlanAttributes.factor}
\alias{QuinlanAttributes.character}
\alias{QuinlanAttributes.ordered}
\alias{QuinlanAttributes.Date}
\alias{QuinlanAttributes.POSIXct}
\alias{QuinlanAttributes.matrix}
\alias{QuinlanAttributes.data.frame}
\alias{makeDataFile}
\alias{makeNamesFile}
\title{Convert Data to Text Format}
\usage{
QuinlanAttributes(object, ...)

\method{QuinlanAttributes}{numeric}(object, ...)

\method{QuinlanAttributes}{factor}(object, ...)

\method{QuinlanAttributes}{character}(object, ...)

\method{QuinlanAttributes}{ordered}(object, ...)

\method{QuinlanAttributes}{Date}(object, ...)

\method{QuinlanAttributes}{POSIXct}(object, ...)

\method{QuinlanAttributes}{matrix}(object, ...)

\method{QuinlanAttributes}{data.frame}(object, ...)

makeDataFile(x, y, w = NULL)

makeNamesFile(x, y, w = NULL, label = "outcome", comments = TRUE)
}
\arguments{
\item{object}{An object to translate to the format expected by
the Quinlan C code.}

\item{x}{A data frame or matrix or predictors}

\item{y}{A vector of outcomes}

\item{w}{A numeric vector of case weights or \code{NULL}}

\item{label}{A string required by the C code as the file name}

\item{comments}{A logical; should info about the call be
printed in the string?}
}
\value{
A textual representation of the data.
}
\description{
This class converts different types of data to a format
required for \href{http://www.rulequest.com/cubist-unix.html}{Cubist}
and \href{http://www.rulequest.com/see5-unix.html}{C5,0}.
}
\keyword{external}
\keyword{internal}
