% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{aconfint}
\alias{aconfint}
\title{Asymptotic confidence intervals for a fitted Cyclops model object}
\usage{
aconfint(
  object,
  parm,
  level = 0.95,
  control,
  overrideNoRegularization = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted Cyclops model object}

\item{parm}{A specification of which parameters require confidence intervals,
either a vector of numbers of covariateId names}

\item{level}{Numeric: confidence level required}

\item{control}{A \code{"cyclopsControl"} object constructed by \code{\link{createControl}}}

\item{overrideNoRegularization}{Logical: Enable confidence interval estimation for regularized parameters}

\item{...}{Additional argument(s) for methods}
}
\value{
A matrix with columns reporting lower and upper confidence limits for each parameter.
These columns are labelled as (1-level) / 2 and 1 - (1 - level) / 2 in %
(by default 2.5% and 97.5%)
}
\description{
\code{aconfinit} constructs confidence intervals of
arbitrary level using asymptotic standard error estimates.
}
\keyword{internal}
