% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpops.R
\name{getpops}
\alias{getpops}
\title{Gets appropriate gate set IDs for populations of interest}
\usage{
getpops(popsofinterest, exptno, cyto_session)
}
\arguments{
\item{popsofinterest}{- Names of gates of interest in Cytobank as list of strings}

\item{exptno}{- Integer representing an experiment ID on Cytobank account}

\item{cyto_session}{- API authentication token for session}
}
\value{
Returns a list of gateSetIDs for populations of interest with names of populations as names of list
}
\description{
Gets appropriate gate set IDs for populations of interest
}
\examples{
\donttest{
library(CytobankAPI)
popsofinterest<-c("CD4 T cells","NK cells")
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
exptno<-2
getpops(popsofinterest,exptno,cyto_session)}
}
