% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{predict,D2C-method}
\alias{predict,D2C-method}
\title{predict if there is a connection between node i and node j}
\usage{
\S4method{predict}{D2C}(object, i, j, data)
}
\arguments{
\item{object}{: a D2C object}

\item{i}{:  index of putative cause (\eqn{1 \le i \le n})}

\item{j}{: index of putative effect (\eqn{1 \le j \le n})}

\item{data}{: dataset of observations from the DAG}
}
\value{
list with  response and prob of the prediction
}
\description{
predict if there is a connection between node i and node j
}
\examples{
require(RBGL)
require(gRbase)
data(example)
## load the D2C object
testDAG<-new("simulatedDAG",NDAG=1, N=50,noNodes=5,
           functionType = "linear", seed=1,sdn=c(0.25,0.5))
## creates a simulatedDAG object for testing
plot(testDAG@list.DAGs[[1]])
## plot the topology of the simulatedDAG
predict(example,1,2, testDAG@list.observationsDAGs[[1]])
## predict if the edge 1->2 exists
predict(example,4,3, testDAG@list.observationsDAGs[[1]])
## predict if the edge 4->3 exists
predict(example,4,1, testDAG@list.observationsDAGs[[1]])
## predict if the edge 4->1 exists
}
\references{
Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
}

