% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.SingleVoting.R
\name{SingleVoting}
\alias{SingleVoting}
\title{Manages the execution of Simple Votings.}
\description{
The class is responsible of initializing and executing voting
schemes. Additionally, to ensure a proper operation, the class automatically
checks the compatibility of defined voting schemes.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{SimpleVoting}},
\code{\link{CombinedVoting}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Super class}{
\code{\link[D2MCS:VotingStrategy]{D2MCS::VotingStrategy}} -> \code{SingleVoting}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SingleVoting$new()}}
\item \href{#method-execute}{\code{SingleVoting$execute()}}
\item \href{#method-clone}{\code{SingleVoting$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getMetrics">}\href{../../D2MCS/html/VotingStrategy.html#method-getMetrics}{\code{D2MCS::VotingStrategy$getMetrics()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getName">}\href{../../D2MCS/html/VotingStrategy.html#method-getName}{\code{D2MCS::VotingStrategy$getName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="VotingStrategy" data-id="getVotingSchemes">}\href{../../D2MCS/html/VotingStrategy.html#method-getVotingSchemes}{\code{D2MCS::VotingStrategy$getVotingSchemes()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
The function initializes the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SingleVoting$new(voting.schemes, metrics)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{voting.schemes}}{A \link{vector} of voting schemes inheriting from
\code{\link{SimpleVoting}} class.}

\item{\code{metrics}}{A \link{list} containing the metrics used as basis to
perform the voting strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute"></a>}}
\if{latex}{\out{\hypertarget{method-execute}{}}}
\subsection{Method \code{execute()}}{
The function is used to execute all the previously defined
(and compatible) voting schemes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SingleVoting$execute(predictions, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \code{\link{ClusterPredictions}} object containing
all the predictions computed in the classification stage.}

\item{\code{verbose}}{A \link{logical} value to specify if more verbosity is needed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SingleVoting$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
