% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modid.R
\name{modid}
\alias{modid}
\title{D3mirt Model Identification}
\usage{
modid(
  x,
  efa = TRUE,
  factors = 3,
  lower = 0.5,
  upper = 0.1,
  fac.order = NULL,
  itemtype = "graded",
  method = "EM",
  rotate = "oblimin",
  ...
)
}
\arguments{
\item{x}{A data frame with item data or item factor loadings that fit the multidimensional graded response model (MGRM) or the multidimensional 2-parameter logistic model (M2PL).}

\item{efa}{Logical, if the data should be explored with exploratory factor analysis (EFA). The default is \code{efa = TRUE}.}

\item{factors}{The number of factors for the exploratory factor analysis. The default is \code{factors = 3}.}

\item{lower}{The lower bound for the item pool, calculated using the standard deviation of scaled item factor loadings. The default is \code{lower = 0.5}.}

\item{upper}{The upper bound for the filtering of absolute sum scores less than or equal to the indicated value. The default is \code{upper = .10}}

\item{fac.order}{Optional. Users can override the automatic sorting of factors by manually indicating factor order with integer values, e.g., \code{c(2,1,3)} to start with the second factor (or column) in data frame x, followed by the first factor (or column) in x, and then lastly the third factor (or column).
The default is \code{fac.order = NULL}.}

\item{itemtype}{The item model for the exploratory factor analysis. Note, only item type 'graded' (for the MGRM) or '2PL' (for the M2PL) are allowed. The default is \code{itemtype = "graded"}. See \link[mirt:mirt]{mirt::mirt} (Chalmers, 2012) for more on item models.}

\item{method}{A string indicating what integration algorithm to use for the EFA. The default is \code{method = 'QMCEM'}. See \link[mirt:mirt]{mirt::mirt} (Chalmers, 2012) for more on methods.}

\item{rotate}{A string indicating what rotation method to use for the EFA. The default is \code{rotate = "oblimin"}. See \link[mirt:mirt]{mirt::mirt} (Chalmers, 2012) for more on rotations.}

\item{...}{Any additional arguments passed to mirt().}
}
\value{
A S3 object of class \code{modid} with lists of items and absolute sum scores, sorted by the latter, and sum of squared factor loadings and frame with raw factor loadings with columns ordered on explained variance (high to low) or according to user settings.
}
\description{
\code{modid()} performs model identification for descriptive multidimensional item response theory (DMIRT) models by indicating what items, from a set or scale, to use to identify the DMIRT model.
}
\details{
Before performing DMIRT analysis it is necessary to identify the compensatory model (Reckase, 2009).
For a three-dimensional model, this entails that two items must be chosen and their loadings restricted as follows.
The first item is fixed not to load on the second and third axes (y and z), while the second item is fixed not to load on the third axis (z).
If this can be empirically achieved, it will be possible to create the orthogonal structure necessary for a three-dimensional DMIRT model.

The \code{modid()} function can help by suggesting what items to use for this purpose.
This is done by the function by first performing an EFA on the data and then selecting the strongest loading items, following the order of strength of the factors, in accordance with the statistical assumptions described above.
This orders the entire model so that the strongest loading item, from the strongest factor, always aligns with the x-axis and the other items follow thereon.
Note, the \code{modid()} function is not limited to three-dimensional analysis and can be used to identify a DMIRT model on any number of dimensions.

Because \code{D3mirt} analysis is based on the M2PL and the MGRM, it is recommended to use multidimensional item response theory EFA methods, such as the EFA option in \link[mirt:mirt]{mirt::mirt} (Chalmers, 2012) with \code{ìtemtype = 'graded'} or \code{'2PL'}, so that the EFA is performed with the proper item model.
For this reason, the \code{mirt()} function is integrated into \code{modid()} so that the user needs only to provide the data frame containing empirical item data in the first argument in the call to the function.
Accordingly, in the default mode (\code{efa = TRUE}), using raw item data, the function performs an EFA with three factors as default (\code{factors = 3}), and then finishes with the model identification.

However, it is also possible to use the \code{modid()} function without performing the EFA by setting \code{efa = FALSE}, if, for instance, a factor loading data frame is already available.
This allows the function to move directly to the model identification step.

Note, the EFA is only used to find model identification items that meet the necessary DMIRT model specification requirements.
The EFA model itself is discarded after this step in the procedure and the user can, therefore, try different types of rotation methods and compare the results.

Running the function prints the number of items and factors together with the suggested model identification items to the console and the summary function is used to inspect the full results.
The latter includes data frames that hold all the model identification items (\code{Item.1...Item.n}) selected by \code{modid()} together with the items absolute sum score (\code{ABS}), one frame for the sum of squares for factors sorted in descending order, and one frame for item factor loadings.
The order of the factors follows the model identification items so that item 1 comes from the strongest factor, item 2 from the second strongest factor, and so on.

Model identification items should preferably (a) have an absolute sum score of less than or equal to .10 and (b) have the highest factor loading scores on the factor of interest.
Of these two criteria, (a) should be given the strongest weight in the selection decision.
If these conditions cannot be met, the user is advised to proceed with caution since the loading scores, therefore, imply that an adequate orthogonal structure may not be empirically attainable.
For more details on the model identification process and troubleshooting please see the package vignette.
}
\examples{
\donttest{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[,3:22] # Remove columns for age and gender

# Identify the DMIRT model using a three-factor EFA
g <- modid(x)

# Optional: Load the EFA data for this example directly from the package file
# load(system.file("extdata/efa.Rdata", package = "D3mirt"))

# Call to summary
summary(g)

# Call to modid with increased lower and upper bound
modid(x, lower = 1, upper = 1 )

# Override factor order by reversing columns in the original data frame
modid(x, fac.order = c(3,2,1))
}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.

Reckase, M. D. (2009). \emph{Multidimensional Item Response Theory}. Springer.
}
\author{
Erik Forsberg
}
