% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any_outgroup.R
\name{any_outgroup}
\alias{any_outgroup}
\title{Checks whether the phylogeny has an outgroup that is not present on the
island. This is critical when extracting data from the phylogeny so the
stem age (colonisation time) is correct.}
\usage{
any_outgroup(phylod)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}
}
\value{
Boolean
}
\description{
Checks whether the phylogeny has an outgroup that is not present on the
island. This is critical when extracting data from the phylogeny so the
stem age (colonisation time) is correct.
}
\examples{
set.seed(
  1,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- sample(c("not_present", "endemic", "nonendemic"),
                            size = length(phylobase::tipLabels(phylo)),
                            replace = TRUE)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
any_outgroup(phylod)
}
