% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{dbWithTransaction}
\alias{dbBreak}
\alias{dbWithTransaction}
\title{Self-contained SQL transactions}
\usage{
dbWithTransaction(conn, code)

dbBreak()
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{code}{An arbitrary block of R code}
}
\value{
The result of the evaluation of \code{code}
}
\description{
Given that \link{transactions} are implemented, this function
allows you to pass in code that is run in a transaction.
The default method of \code{dbWithTransaction} calls \code{\link{dbBegin}}
before executing the code,
and \code{\link{dbCommit}} after successful completion,
or \code{\link{dbRollback}} in case of an error.
The advantage is
that you don't have to remember to do \code{dbBegin} and \code{dbCommit} or
\code{dbRollback} -- that is all taken care of.
The special function \code{dbBreak} allows an early exit with rollback,
it can be called only inside \code{dbWithTransaction}.
}
\section{Side Effects}{

The transaction in \code{code} on the connection \code{conn} is committed
or rolled back. The \code{code} chunk may also modify the local R
environment.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "cars", head(cars, 3))
dbReadTable(con, "cars")   # there are 3 rows

## successful transaction
dbWithTransaction(con, {
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (1, 1);")
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (2, 2);")
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (3, 3);")
})
dbReadTable(con, "cars")   # there are now 6 rows

## failed transaction -- note the missing comma
tryCatch(
  dbWithTransaction(con, {
    dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (1, 1);")
    dbExecute(con, "INSERT INTO cars (speed dist) VALUES (2, 2);")
    dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (3, 3);")
  }),
  error = identity
)
dbReadTable(con, "cars")   # still 6 rows

## early exit, silently
dbWithTransaction(con, {
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (1, 1);")
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (2, 2);")
  if (nrow(dbReadTable(con, "cars")) > 7) dbBreak()
  dbExecute(con, "INSERT INTO cars (speed, dist) VALUES (3, 3);")
})
dbReadTable(con, "cars")   # still 6 rows

dbDisconnect(con)
}

