\name{Km}
\alias{Km}
\title{Matrix K}
\usage{
Km(m = 3, nu = 0, J = NULL, Q = NULL)
}
\arguments{
  \item{m}{a positive integer greater or equal than \eqn{nu} indicating the size of the window for the polinomial fit.}
  \item{nu}{a non-negative integer denoting the degree of the polinomial fit applied on the integrated series.}
  \item{J, Q}{optional: the matrices such that \eqn{K = J'QJ}. If both matrices are provided, \eqn{m} and \eqn{nu} are ignored.}
}
\value{
  an \eqn{m+1} by \eqn{m+1} matrix corresponding to expression (18) in Prass and Pumi (2019).
}
\description{
This is an auxiliary function which computes expression (18) in Prass and Pumi (2019). It creates an \eqn{m+1} by \eqn{m+1}  matrix defined by \eqn{K = J'QJ} where \eqn{J} is a \eqn{m+1} by \eqn{m+1} lower triangular matrix with all non-zero entries equal to one and \eqn{Q} is a \eqn{m+1} by \eqn{m+1} given by \eqn{Q = I - P} where \eqn{P} is the projection matrix into the subspace generated by degree \eqn{nu+1} polynomials and \eqn{I} is the \eqn{m+1} by \eqn{m+1}  identity matrix.
}
\examples{
K = Km(m = 3, nu = 0)
K
# same as
m = 3
J = Jn(n = m+1)
Q = Qm(m = m, nu = 0)
K = Km(J = J, Q = Q)
K

}

\references{Prass, T.S. and Pumi, G. (2019). On the behavior of the DFA and DCCA in trend-stationary
processes <arXiv:1910.10589>.}
\author{Taiane Schaedler Prass}
\seealso{\code{\link{Jn}} which creates the matrix \eqn{J}, \code{\link{Qm}} which creates \eqn{Q} and \code{\link{Pm}} which creates \eqn{P}.}
