% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_heap.R
\name{build_heap}
\alias{build_heap}
\title{build_heap: Part of DCEM package.}
\usage{
build_heap(data)
}
\arguments{
\item{data}{(dataframe): The dataframe containing the key, value pairs.}
}
\value{
data frame: The dataframe containing the heap.
}
\description{
Create the heap from the data frame. This function is for internal use and is called
by the \code{\link{dcem_star_cluster_uv}} (univariate data) and
\code{\link{dcem_star_cluster_mv}} (multivariate data).
}
\examples{
# Create a sample data frame
heap <- data.frame(keys=c(0,3,4), vals=c(7,7,4))

# Build the heap from the data frame.
heap <- build_heap(heap)

}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <doi:https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic
This work is partially supported by NCI Grant 1R01CA213466-01.
}
