% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_xvt_results.R
\name{get_xvt_results}
\alias{get_xvt_results}
\title{Get results of DCPO cross-validation testing}
\usage{
get_xvt_results(dcpo_xvt_output, ci = 80)
}
\arguments{
\item{dcpo_xvt_output}{output from a single call to \code{DCPO::dcpo_xvt} or a k-fold test list of such output generated by purrr::map}

\item{ci}{an integer indicating the desired width of credible interval for coverage testing; 80 is the default.}
}
\value{
a stanfit object
}
\description{
\code{get_xvt_results} performs a single cross-validation test for dcpo's estimates of cross-national public opinion
}
\examples{
\donttest{
demsup <- read_csv(system.file("extdata", "all_data_demsupport.csv", package = "DCPOtools"))

demsup_data <- format_dcpo(with_min_yrs(demsup, 3),
                           scale_q = "church_21",
                           scale_cp = 2)

# Single cross-validation test with 25% test set
dcpo_demsup_xvtest <- dcpo_xvt(demsup_data,
                           number_of_folds = 4,
                           iter = 150)

get_xvt_results(dcpo_demsup_xvtest)

# k-fold cross-validation with 10 folds (dcpo_demsup_kfold will be a list of stanfit objects)
dcpo_demsup_kfold <- purrr::map(1:10, function(x) {
                              dcpo_xvt(demsup_data,
                                         fold_number = x, # number_of_folds = 10 is the default
                                         iter = 150)
                                         })

get_xvt_results(dcpo_demsup_kfold)

}
}
