% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testValid.R
\name{testValid}
\alias{testValid}
\title{Validate a DDI element.}
\usage{
testValid(element, monolang = TRUE)
}
\arguments{
\item{element}{A standard element of class \code{"DDI"}.}

\item{monolang}{Logical, the codebook file is monolingual}
}
\value{
A character vector of validation problems found.
}
\description{
Attempts a minimal validation of a DDI Codebook element, by
searching for mandatory elements and attributes.
}
\details{
This function currently attempts a minimal check for the absolute
most mandatory elements, such as the \code{stdyDscr}. An absolute bare version
of this element, filled with arbitrary default values, can be produced with
the function \code{makeElement()}, activating its attribute \code{fill}.
It also checks for chained expectations, that is element X is mandatory only
if the parent element is present.

Future versions will implement more functionality for recommended elements
and attributes, with the intention to provide a 1:1 validation as offered by
the "CESSDA Metadata Validator".

To ease the validation of the DDI Codebook XML files, the argument \code{monolang}
is activated by default. This means a single attribute \code{xmlang} in the main
\code{codeBook} element. For multi-language codebooks, an error is flagged if this
argument is missing where appropriate.
}
\seealso{
\code{\link{makeElement}}
}
\author{
Adrian Dusa
}
