% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{Gumbel}
\alias{Gumbel}
\title{Estimated Density Values by Gumbel kernel}
\usage{
Gumbel(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated Kernel density values by using Gumbel Kernel.
}
\details{
The Gumbel kernel is developed by Khan and Akbar (2020). They provided evidence that performance of their proposed is better then Weibull kernel especially when data belongs to family of extreme distributions.
Gumbel Kernel is
\deqn{K_{Gumbel(x, \sqrt{h})}(j)=\frac{1}{\sqrt{h}}exp-\left( \frac{j-x}{\sqrt{h}} +exp\left( \frac{j-x}{\sqrt{h}}\right) \right)}
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
Gumbel(y,200,h)
}
\references{
Khan, J. A.; Akbar, A. Density Estimation by Gumbel Kernel. 2020. \emph{Working paper,  Department of Statistics, Bahauddin Zakariya University, Multan, Pakistan.}
}
\seealso{
For esitimated values by Weibull kernel see \code{\link{Weibull}}. Further, for plot and MSE by Gumbel kernel see \code{\link{plot.Gumbel}} and \code{\link{msegumbel}}, respectively.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
