% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{msegumbel}
\alias{msegumbel}
\title{Calculate Mean Square Error( MSE) when Gumbel kernel is used.}
\usage{
msegumbel(y, k, h, type)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{type}{mention distribution of vector.If Gumbel distribution is used scale=1 then use \code{"Gumbel"}.
if use Weibull distribution with scale = 1 then use \code{"Weibull"}.
if use Frechet distribution with scale=1 and shape=1 then use \code{"Frechet"}.}
}
\value{
MSE
}
\description{
Calculate MSE by using Gumbel Kernel.
}
\examples{
y<-rweibull(350,1)
h<-0.79 * IQR(y) * length(y) ^ (-1/5)
msegumbel(y,200,h,"Weibull")
}
\references{
Khan, J. A.; Akbar, A. Density Estimation by Gumbel Kernel. 2020. \emph{Working paper,  Department of Statistics, Bahauddin Zakariya University, Multan, Pakistan.}
}
\seealso{
For Weibull estimator MSE see \code{\link{mseweibull}}. For density estimation by using Gumbel Kernel \code{\link{plot.Gumbel}} and for estimated values
of density \code{\link{Gumbel}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar
}
