% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{mseweibull}
\alias{mseweibull}
\title{Calculate Mean Square Error( MSE) when Weibull kernel is used.}
\usage{
mseweibull(y, k, h, type)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{type}{mention distribution of vector.If Gumbel distribution is used scale=1 then use \code{"Gumbel"}.
if use Weibull distribution with scale = 1 then use \code{"Weibull"}.
if use Frechet distribution with scale=1 and shape=1 then use \code{"Frechet"}.}
}
\value{
MSE
}
\description{
Calculate MSE by using Weibull Kernel.
}
\examples{
y<-rweibull(350,1)
h<-0.79 * IQR(y) * length(y) ^ (-1/5)
mseweibull(y,200,h,"Weibull")
}
\references{
Salha, R. B., El Shekh Ahmed, H. I., & Alhoubi, I. M. 2014. Hazard Rate Function Estimation Using Weibull Kernel. \emph{Open Journal of Statistics} \strong{4} (08), 650-661.
}
\seealso{
For Gumbel estimator MSE see \code{\link{msegumbel}}. For density estimation by using Weibull Kernel \code{\link{plot.Weibull}} and for estimated values
of density \code{\link{Weibull}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar
}
