% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{rand.test}
\alias{rand.test}
\title{Randomization test for Patel's kappa. Creates a distribution of values
kappa under the null hypothesis.}
\usage{
rand.test(X, alpha = 0.05, K = 1000)
}
\arguments{
\item{X}{time x node x subjects 3D matrix.}

\item{alpha}{sign. level}

\item{K}{number of randomizations, default is 1000.}
}
\value{
stat lower and upper significance thresholds.
}
\description{
Randomization test for Patel's kappa. Creates a distribution of values
kappa under the null hypothesis.
}
\examples{
# create some sample data with 200 samples,
# 3 nodes, and 2 subjects
ts = array(rnorm(200*3*5), dim=c(200,3,5))
mysubs=list()
mysubs[[1]]=patel(ts[,,1])
mysubs[[2]]=patel(ts[,,2])
mysubs[[3]]=patel(ts[,,3])
mysubs[[4]]=patel(ts[,,4])
mysubs[[5]]=patel(ts[,,5])
g=patel.group(mysubs)
r=rand.test(rmdiag(g$kappa), K=100)
}
