% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Mixed.R
\name{makeMeanMP}
\alias{makeMeanMP}
\title{Create an MP that averages the results of multiple MPs}
\usage{
makeMeanMP(MPs)
}
\arguments{
\item{MPs}{A vector of MPs names}
}
\value{
A function of class \code{MP}
}
\description{
This function takes a character string of MP names and returns
a function of class\code{MP} that calculates the average of the management recommendations
from the individual MPs.
}
\note{
See relevant section of the \href{https://dlmtool.github.io/DLMtool/userguide/averaging-mps.html}{DLMtool User Guide} for more information.
}
\examples{
\dontrun{
MeanMP <- makeMeanMP(c("AvC", "DCAC"))
MSE <- runMSE(DLMtool::testOM, MPs=c("AvC", "DCAC", "MeanMP"))
Tplot2(MSE)

MeanMP <- makeMeanMP(c("matlenlim", "matlenlim2")) 
Data <- DLMtool::SimulatedData
matlenlim(1, Data)
matlenlim2(1, Data)
MeanMP(1, Data)
}
}
\author{
A. Hordyk
}
