% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ki_precomp.R
\name{ki.precompute}
\alias{ki.precompute}
\title{Pre-computes KIs for use with \code{ki.db} function}
\usage{
ki.precompute(type, freqs, markers = names(freqs), theta = 0)
}
\arguments{
\item{type}{A character string giving the type of KI. See \link{ibdprobs}.}

\item{freqs}{A list specifying the allelic frequencies. Should contain a vector of allelic frequencies for each locus, named after that locus.}

\item{markers}{Character vector stating the markers to use in the KI computation. Defaults to all markers contained in \code{freqs}.}

\item{theta}{numeric value specifying the amount of background relatedness.}
}
\value{
list A list of numeric vectors containing the KIs for all genotypic combinations at each locus.
}
\description{
Pre-computes KIs for use with \code{ki.db} function
}
\details{
In large scale simulation studies, it is sometimes useful to precompute KIs to speedup computations.
}
\examples{
\dontrun{
data(freqsNLngm);
n <- 1e6

targets <- sample.profiles(N = 1e2,freqs = freqsNLngm)
db <- sample.profiles(N = 1e5,freqs = freqsNLngm)

precomp <- ki.precompute(type = "FS",freqs = freqsNLngm)

R1 <- ki.db(x = targets,db = db,hyp.1 = "FS")
R2 <- ki.db(x = targets,db = db,precomputed.kis = precomp) # a little faster

all.equal(R1,R2)

}
}
\seealso{
\link{ki.db}
}

