% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdid_imp_rc1.R
\name{drdid_imp_rc1}
\alias{drdid_imp_rc1}
\title{Improved doubly robust DiD estimator for the ATT, with repeated cross-section data}
\usage{
drdid_imp_rc1(
  y,
  post,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of outcomes from the both pre and post-treatment periods.}

\item{post}{An \eqn{n} x \eqn{1} vector of Post-Treatment dummies (post = 1 if observation belongs to post-treatment period,
and post = 0 if observation belongs to pre-treatment period.)}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the propensity score and regression estimation. Please add a vector of constants if you want to include an intercept in the models.
If covariates = NULL, this leads to an unconditional DiD estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
\item{ATT}{The DR DiD point estimate}
\item{se}{ The DR DiD standard error}
\item{uci}{Estimate of the upper bound of a 95\% CI for the ATT}
\item{lci}{Estimate of the lower bound of a 95\% CI for the ATT}
\item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
 \item{ps.flag}{Convergence Flag for the propensity score estimation: =0 if \code{trust} algorithm converged,
   =1 if IPW algorithm converged (in case it was used), =2 if GLM logit estimator was used (i.e., if both \code{trust} and IPT
   did not converged).}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = FALSE, estMethod = "imp2", boot, boot.type, nboot, type="dr")}
}
\description{
\code{drdid_imp_rc1} is used to compute the doubly robust estimators for the ATT
 in difference-in-differences (DiD) setups with stationary repeated cross-sectional data. The resulting estimator is also doubly robust for inference,
 though it is not locally efficient; see Section 3.2 of Sant'Anna and Zhao (2020).
}
\details{
The \code{drdid_imp_rc1} function implements the doubly robust difference-in-differences (DiD)
estimator for the average treatment effect on the treated (ATT) defined in equation (3.3)
in Sant'Anna and Zhao (2020). This estimator makes use of a logistic propensity score model for the probability
of being in the treated group, and of (separate) linear regression models for the outcome among the comparison units in both pre and
post-treatment time periods. Importantly, this estimator is not locally efficient for the ATT.


The nuisance parameters (propensity score and outcome regression parameters) are estimated using the methods
described in Sections 3.2 of Sant'Anna and Zhao (2020). In short, the propensity score parameters are estimated
using the inverse probability tilting estimator proposed by Graham, Pinto and Pinto (2012), and the outcome
regression coefficients are estimated using weighted least squares,where the weights depend on
the propensity score estimates; see Sant'Anna and Zhao (2020) for details.


The resulting estimator is not only doubly robust for the ATT,
but it is also doubly robust for inference. However, we stress that it is not locally efficient;
see Sant'Anna and Zhao (2020) for details.
}
\examples{
# use the simulated data provided in the package
covX = as.matrix(cbind(1, sim_rc[,5:8]))
# Implement the improved DR DiD estimator (but not locally efficient!)
drdid_imp_rc1(y = sim_rc$y, post = sim_rc$post, D = sim_rc$d,
             covariates= covX)

}
\references{
\cite{Graham, Bryan, Pinto, Cristine, and Egel, Daniel (2012),
"Inverse Probability Tilting for Moment Condition Models with Missing Data."
 Review of Economic Studies, vol. 79 (3), pp. 1053-1079, \doi{10.1093/restud/rdr047}}


\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
\doi{10.1016/j.jeconom.2020.06.003}}
}
