% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_introduction.R
\name{simulate_introduction}
\alias{simulate_introduction}
\title{Simulation of a basic SIR model illustrating a single infectious disease outbreak}
\usage{
simulate_introduction(S0 = 1000, I0 = 1, tmax = 300, g = 0.5,
  b = 1/1000)
}
\arguments{
\item{S0}{initial number of susceptible individuals}

\item{I0}{initial number of infected hosts}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{g}{rate at which a person leaves the infectious compartment, which
is the inverse of the average duration of the infections period}

\item{b}{level of infectiousness, i.e. rate of transmission of pathogen
from infected to susceptible host}
}
\value{
The function returns the output from the odesolver as a matrix,
with one column per compartment/variable. The first column is time.
}
\description{
This function runs a simulation of a basic SIR model
using a set of 3 ordinary differential equations.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a matrix containing time-series of each variable and time.
}
\details{
A simple SIR model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message
}

\examples{
# To run the simulation with default parameters just call this function
result <- simulate_introduction()
# To choose parameter values other than the standard one, specify them e.g. like such
result <- simulate_introduction(S0 = 2000, I0 = 10, tmax = 100, g = 1, b = 1/100)
# You should then use the simulation result returned from the function, e.g. like this:
plot(result[,1],result[,2],xlab='Time',ylab='Number Susceptible',type='l')
}
\seealso{
See the shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
