% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/PT.Design.R, R/LT.Design.R, R/Simulation.R
\docType{methods}
\name{generate.transects}
\alias{generate.transects}
\alias{generate.transects,LT.Design-method}
\alias{generate.transects,PT.Design-method}
\alias{generate.transects,Simulation-method}
\title{S4 generic method to generate an instance of a design}
\usage{
generate.transects(object, read.from.file = TRUE, write.to.file = FALSE,
  region = NULL, ...)

\S4method{generate.transects}{PT.Design}(object, read.from.file = TRUE,
  write.to.file = FALSE, region = NULL, index = NULL)

\S4method{generate.transects}{LT.Design}(object, read.from.file = TRUE,
  write.to.file = FALSE, region = NULL, index = NULL)

\S4method{generate.transects}{Simulation}(object, read.from.file = TRUE,
  write.to.file = FALSE, region = NULL)
}
\arguments{
\item{object}{an object of class Simulation or a class which inherits from 
Survey.Design}

\item{read.from.file}{if the transect details should be read in from file 
(currently must be TRUE)}

\item{write.to.file}{not currently implemented}

\item{region}{optional only required if object is of class Survey.Design.}

\item{...}{optional argument index if an object of class Survey.Design is 
supplied allowing the user to access / plot different sets of transects
listed in the filenames slot.}

\item{index}{specifies which set of transect should be loaded}
}
\value{
an object of class Line.Transect
}
\description{
Uses the Survey.Design details to generate transects. Currenty this 
involves loading a survey shapefile from the path specified in the 
Survey.Design object and can only work with line transect designs.
}

