% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollback.R
\name{rollback}
\alias{rollback}
\title{Rollback Month}
\usage{
rollback(.dateTime, periodicity)
}
\arguments{
\item{.dateTime}{A \code{\link{POSIXct}} vector.}

\item{periodicity}{A character string specifying a multiple of month(s) or
year(s). See \code{\link{seq.POSIXt}} for further information.}
}
\value{
Returns a \code{\link{POSIXct}} vector.
}
\description{
Generating regular sequences of times with the help of
 \code{\link{seq.POSIXt}} can have undesirable effects. This function
 \dQuote{first advances the month without changing the day: if this results
 in an invalid day of the month, it is counted forward into the next month}.
 Monthly or yearly sequences starting at the end of a month with 30 or 31
 days (or 29 in case of a leap year) therefore do not always fall on the end
 of shorter months. \code{rollback} reverts this process by counting the days
 backwards again.
}
\examples{
# rollback monthly time series
by <- "1 month"
rollback(
  .dateTime = seq(
    from = as.POSIXct("2000-01-31", tz = "UTC"),
    to = as.POSIXct("2000-12-31", tz = "UTC"),
    by = by
  ),
  periodicity = by
)

}
\seealso{
\code{\link{seq.POSIXt}}, \code{\link{POSIXct}}
}
