% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{summary.DTSg}
\alias{summary.DTSg}
\alias{summary}
\title{Summarise time series data}
\usage{
\method{summary}{DTSg}(object, cols = self$cols(), ...)
}
\arguments{
\item{object}{A \code{\link{DTSg}} object (S3 method only).}

\item{cols}{A character vector specifying the columns whose values shall be
summarised. Another possibility is a character string containing either
comma separated column names, for example, \code{"x,y,z"}, or the start and end
column separated by a colon, for example, \code{"x:z"}.}

\item{\dots}{Further arguments passed on to \code{\link{summary.data.frame}}.}
}
\value{
Returns a \code{\link{table}}.
}
\description{
Calculates summary statistics of selected columns of a \code{\link{DTSg}} object.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# calculate summary statistics
## R6 method
x$summary()

## S3 method
summary(object = x)

}
\seealso{
\code{\link{cols}}
}
