% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSync.R
\name{dataSync}
\alias{dataSync}
\alias{dataSyncUI}
\alias{dataSyncServer}
\title{A shiny module to synchronise datasets}
\usage{
dataSyncUI(id)

dataSyncServer(
  id,
  data = reactive(NULL),
  data_subset = reactive(NULL),
  rows = reactive(NULL),
  columns = reactive(NULL),
  hide = FALSE,
  hover_text = NULL
)
}
\arguments{
\item{id}{unique identifier for the module to prevent namespace clashes when
making multiple calls to this shiny module.}

\item{data}{master copy of the data.}

\item{data_subset}{subset of \code{data} with altered entries.}

\item{rows}{the row indices of \code{data_subset} within \code{data}.}

\item{columns}{the column indices of \code{data_subset} within \code{data}.}

\item{hide}{logical indicating whether the data synchronisation user
interface should be hidden from the user, set to FALSE by default.}

\item{hover_text}{text to display on download button when user hovers cursor
over button, set to NULL by default to turn off hover text.}
}
\description{
The purpose of this module is to merge changes made to a subset of the data
with the master copy of the data.
}
\examples{
if(interactive()){
 library(shiny)
 library(rhandsontable)
 library(shinyjs)

 ui <- fluidPage(
   useShinyjs(),
   dataInputUI("input1"),
   dataFilterUI("filter1"),
   dataSyncUI("sync1"),
   dataEditUI("edit1")
 )

 server <- function(input,
                    output,
                    session) {

   values <- reactiveValues(
     data = NULL,
     data_subset = NULL
   )

   data_input <- dataInputServer("input1")

  data_edit <- dataEditServer(
     "edit1",
     data = data_input
   )

   data_sync <- dataSyncServer(
     "sync1",
     data = data_input,
     data_subset = data_edit,
     rows = NULL,
     columns = NULL
   )

  }
 shinyApp(ui, server)
}

}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
