% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processData.R
\name{document}
\alias{document}
\title{Build documentation for a data package using DataPackageR.}
\usage{
document(path = ".", install = TRUE, ...)
}
\arguments{
\item{path}{\code{character} the path to the data package source root.}

\item{install}{\code{logical} install and reload the package. (default TRUE)}

\item{...}{additional arguments to \code{install}}
}
\description{
Build documentation for a data package using DataPackageR.
}
\examples{
# A simple Rmd file that creates one data object
# named "tbl".
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f,"foo.Rmd")
con <- file(f)
writeLines("```{r}\\n tbl = table(sample(1:10,100,replace=TRUE)) \\n```\\n",con=con)
close(con)

# construct a data package skeleton named "MyDataPackage" and pass
# in the Rmd file name with full path, and the name of the object(s) it
# creates.

pname <- basename(tempfile())
datapackage_skeleton(name=pname,
   path=tempdir(),
   force = TRUE,
   r_object_names = "tbl",
   code_files = f)

# call package_build to run the "foo.Rmd" processing and
# build a data package.
package_build(file.path(tempdir(), pname), install = FALSE)
document(path = file.path(tempdir(), pname), install=FALSE)
}
}
