% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.R
\name{use_raw_dataset}
\alias{use_raw_dataset}
\title{Add a raw data set to inst/extdata}
\usage{
use_raw_dataset(path = NULL, ignore = FALSE)
}
\arguments{
\item{path}{\code{character} path to file or directory.}

\item{ignore}{\code{logical} whether to ignore the path or file in git and R build.}
}
\value{
invisibly returns TRUE for success. Stops on failure.
}
\description{
The file or directory specified by \code{path} will be moved into
the inst/extdata directory.
}
\examples{
if(rmarkdown::pandoc_available()){
myfile <- tempfile()
file <- system.file("extdata", "tests", "extra.rmd",
                     package = "DataPackageR")
raw_data <- system.file("extdata", "tests", "raw_data",
                        package = "DataPackageR")
datapackage_skeleton(
  name = "datatest",
  path = tempdir(),
  code_files = file,
  force = TRUE,
  r_object_names = "data")
use_raw_dataset(raw_data)
}
}
