% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{lowLevelQuerySql}
\alias{lowLevelQuerySql}
\title{Low level function for retrieving data to a data frame}
\usage{
lowLevelQuerySql(
  connection,
  query,
  datesAsString = FALSE,
  integerAsNumeric = getOption("databaseConnectorIntegerAsNumeric", default = TRUE),
  integer64AsNumeric = getOption("databaseConnectorInteger64AsNumeric", default = TRUE)
)
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[=dbConnect]{dbConnect()}}.}

\item{query}{The SQL statement to retrieve the data}

\item{datesAsString}{Logical: Should dates be imported as character vectors, our should they be converted
to R's date format?}

\item{integerAsNumeric}{Logical: should 32-bit integers be converted to numeric (double) values? If FALSE
32-bit integers will be represented using R's native \code{Integer} class.}

\item{integer64AsNumeric}{Logical: should 64-bit integers be converted to numeric (double) values? If FALSE
64-bit integers will be represented using \code{bit64::integer64}.}
}
\value{
A data frame containing the data retrieved from the server
}
\description{
This is the equivalent of the \code{\link[=querySql]{querySql()}} function, except no error report is written
when an error occurs.
}
\details{
Retrieves data from the database server and stores it in a data frame. Null values in the database are converted
to NA values in R.
}
