/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import java.util.Vector;
import org.rosuda.ibase.Commander;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.QueryPopup;
import org.rosuda.ibase.toolkit.WinTracker;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Tools;

public class FluctCanvas
extends PGSCanvas
implements Dependent,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
Commander {
    SVar[] v;
    SMarker m;
    SVar weight;
    boolean showLabels = true;
    protected QueryPopup qi;
    Axis[] A;
    double[] Counts;
    double[] Marked;
    int v1l;
    int v2l;
    double maxCount;
    int x1;
    int y1;
    int x2;
    int y2;
    boolean drag = false;
    boolean mvX = false;
    boolean mvY = false;
    boolean centered = false;
    int dragNew;
    int mvXstart;
    int mvYstart;
    MenuItem MIlabels = null;
    int X;
    int Y;
    int W;
    int H;
    int TW;
    int TH;

    public FluctCanvas(int n, Frame frame, SVar sVar, SVar sVar2, SMarker sMarker, SVar sVar3) {
        super(n, 2);
        this.weight = sVar3;
        this.setFrame(frame);
        this.setTitle((this.weight == null ? "FD" : "WFD") + " (" + sVar.getName() + " : " + sVar2.getName() + ")" + (this.weight == null ? "" : "*" + this.weight.getName()));
        this.v = new SVar[2];
        this.A = new Axis[2];
        this.v[0] = sVar;
        this.v[1] = sVar2;
        this.m = sMarker;
        this.A[0] = new Axis(sVar, 0, 1);
        this.A[0].addDepend(this);
        this.A[1] = new Axis(sVar2, 1, 1);
        this.A[1].addDepend(this);
        this.setBackground(Common.backgroundColor);
        this.drag = false;
        this.updatePoints();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        frame.addKeyListener(this);
        Object var7_7 = null;
        String[] stringArray = new String[]{"+", "File", "~File.Graph", "~Edit", "+", "View", "@RRotate", "rotate", "@LHide labels", "labels", "Toggle alignment", "center", "~Window", "0"};
        EzMenu.getEzMenu(frame, this, stringArray);
        this.MIlabels = EzMenu.getItem(frame, "labels");
    }

    public FluctCanvas(int n, Frame frame, SVar sVar, SVar sVar2, SMarker sMarker) {
        this(n, frame, sVar, sVar2, sMarker, null);
    }

    public Dimension getMinimumSize() {
        return new Dimension(60, 50);
    }

    public void rotate() {
        SVar sVar = this.v[0];
        this.v[0] = this.v[1];
        this.v[1] = sVar;
        Axis axis = this.A[0];
        this.A[0] = this.A[1];
        this.A[1] = axis;
        try {
            ((Frame)this.getParent()).setTitle("FD (" + this.v[1].getName() + " vs " + this.v[0].getName() + ")");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePoints();
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        this.updatePoints();
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void paintPoGraSS(PoGraSS poGraSS) {
        int n;
        double d;
        Rectangle rectangle = this.getBounds();
        poGraSS.setBounds(rectangle.width, rectangle.height);
        poGraSS.begin();
        poGraSS.defineColor("white", 255, 255, 255);
        poGraSS.defineColor("black", 0, 0, 0);
        poGraSS.defineColor("outline", 0, 0, 0);
        poGraSS.defineColor("red", 255, 0, 0);
        poGraSS.defineColor("marked", Common.selectColor.getRed(), Common.selectColor.getGreen(), Common.selectColor.getBlue());
        poGraSS.defineColor("objects", Common.objectsColor.getRed(), Common.objectsColor.getGreen(), Common.objectsColor.getBlue());
        float[] fArray = Common.selectColor.getRGBComponents(null);
        poGraSS.defineColor("aSelBg", fArray[0], fArray[1], fArray[2], 0.3f);
        Dimension dimension = this.getSize();
        if (dimension.width != this.TW || dimension.height != this.TH) {
            this.updatePoints();
        }
        if (this.TW < 50 || this.TH < 50) {
            poGraSS.setColor("red");
            poGraSS.drawLine(0, 0, this.TW, this.TH);
            poGraSS.drawLine(0, this.TH, this.TW, 0);
            return;
        }
        poGraSS.setColor("black");
        poGraSS.drawLine(this.X, this.Y, this.X, this.Y + this.H);
        poGraSS.drawLine(this.X, this.Y + this.H, this.X + this.W, this.Y + this.H);
        double d2 = this.A[0].getSensibleTickDistance(50, 26);
        for (d = this.A[0].getSensibleTickStart(d2); d < this.A[0].vBegin + this.A[0].vLen; d += d2) {
            if (this.v[0].isCat()) {
                d += 0.2;
            }
            n = this.A[0].getValuePos(d);
            if (this.v[0].isCat()) {
                d -= 0.2;
            }
            poGraSS.drawLine(n, this.Y + this.H, n, this.Y + this.H + 5);
            if (!this.showLabels) continue;
            poGraSS.drawString(this.v[0].isCat() ? this.v[0].getCatAt((int)d).toString() : this.A[0].getDisplayableValue(d), n, this.Y + this.H + 20, 2);
        }
        d2 = this.A[1].getSensibleTickDistance(50, 18);
        for (d = this.A[1].getSensibleTickStart(d2); d < this.A[1].vBegin + this.A[1].vLen; d += d2) {
            if (this.v[1].isCat()) {
                d += 0.2;
            }
            n = this.A[1].getValuePos(d);
            if (this.v[1].isCat()) {
                d -= 0.2;
            }
            poGraSS.drawLine(this.X - 5, n, this.X, n);
            if (!this.showLabels) continue;
            poGraSS.drawString(this.v[1].isCat() ? Common.getTriGraph(this.v[1].getCatAt((int)d).toString()) : this.A[1].getDisplayableValue(d), this.X - 25, n + 5);
        }
        int n2 = 0;
        for (int i = 0; i < this.v2l; ++i) {
            for (int j = 0; j < this.v1l; ++j) {
                double d3 = this.Counts[n2];
                double d4 = this.Marked[n2];
                ++n2;
                if (!(d3 > 0.0)) continue;
                int n3 = this.A[0].getCatLow(j);
                int n4 = this.A[1].getCatLow(i);
                int n5 = this.A[0].getCatUp(j) - n3;
                int n6 = this.A[1].getCatUp(i) - n4;
                if (n5 < 0) {
                    n3 += n5;
                    n5 = -n5;
                }
                if (n6 < 0) {
                    n4 += n6;
                    n6 = -n6;
                }
                poGraSS.setColor("objects");
                int n7 = (int)((double)n5 * Math.sqrt(d3 / this.maxCount));
                int n8 = (int)((double)n6 * Math.sqrt(d3 / this.maxCount));
                int n9 = (int)((double)n8 * d4 / d3);
                if (this.centered) {
                    n3 += (n5 - n7) / 2;
                    n4 += (n6 - n8) / 2;
                } else {
                    n4 += n6 - n8;
                }
                poGraSS.fillRect(n3, n4, n7, n8);
                if (n9 > 0) {
                    poGraSS.setColor("marked");
                    poGraSS.fillRect(n3, n4 + n8 - n9, n7, n9);
                }
                poGraSS.setColor(d4 > 0.0 ? "red" : "black");
                poGraSS.drawRect(n3, n4, n7, n8);
            }
        }
        this.paintDragLayer(poGraSS);
        poGraSS.end();
        this.setUpdateRoot(2);
    }

    void paintDragLayer(PoGraSS poGraSS) {
        if (this.drag || this.mvX || this.mvY) {
            int n;
            int n2;
            int n3;
            this.nextLayer(poGraSS);
            if (this.drag) {
                int n4;
                n3 = this.A[0].clip(this.x1);
                n2 = this.A[1].clip(this.y1);
                n = this.A[0].clip(this.x2);
                int n5 = this.A[1].clip(this.y2);
                if (n3 > n) {
                    n4 = n3;
                    n3 = n;
                    n = n4;
                }
                if (n2 > n5) {
                    n4 = n2;
                    n2 = n5;
                    n5 = n4;
                }
                poGraSS.setColor("aSelBg");
                poGraSS.fillRect(n3, n2, n - n3, n5 - n2);
                poGraSS.setColor("black");
                poGraSS.drawRect(n3, n2, n - n3, n5 - n2);
            }
            if (this.mvX) {
                n3 = this.A[0].getCatLow(this.dragNew);
                n2 = this.A[0].getCatUp(this.dragNew);
                poGraSS.setColor("red");
                if (n2 < n3) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                poGraSS.drawRect(n3, this.Y + this.H, n2 - n3, 2);
            }
            if (this.mvY) {
                n3 = this.A[1].getCatLow(this.dragNew);
                n2 = this.A[1].getCatUp(this.dragNew);
                poGraSS.setColor("red");
                if (n2 < n3) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                poGraSS.drawRect(this.X, n3, 2, n2 - n3);
            }
        }
    }

    public void updatePoints() {
        if (this.qi != null) {
            this.qi.hide();
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.TW = n;
        this.TH = n2;
        int n3 = 30;
        int n4 = 30;
        boolean bl = false;
        int n5 = n - n3 - 10;
        int n6 = n2 - n4 - 10;
        boolean bl2 = this.v[0].isCat();
        boolean bl3 = this.v[1].isCat();
        this.X = n3;
        this.W = n5;
        this.A[0].setGeometry(0, this.X, this.W);
        this.H = n6;
        this.A[1].setGeometry(1, this.TH - n4, -this.H);
        this.Y = this.TH - n4 - n6;
        this.v1l = this.v[0].getNumCats();
        this.v2l = this.v[1].getNumCats();
        this.Counts = new double[this.v1l * this.v2l];
        this.Marked = new double[this.v1l * this.v2l];
        this.maxCount = 0.0;
        int n7 = this.v[0].size();
        if (n7 > this.v[1].size()) {
            n7 = this.v[1].size();
        }
        for (int i = 0; i < n7; ++i) {
            double d;
            int n8 = this.v[0].getCatIndex(i);
            int n9 = this.v[1].getCatIndex(i);
            if (n8 < 0 || n9 < 0) continue;
            double d2 = d = this.weight == null ? 1.0 : this.weight.atD(i);
            if (d < 0.0) {
                d = -d;
            }
            int n10 = n8 + n9 * this.v1l;
            this.Counts[n10] = this.Counts[n10] + d;
            if (this.Counts[n8 + n9 * this.v1l] > this.maxCount) {
                this.maxCount = this.Counts[n8 + n9 * this.v1l];
            }
            if (!this.m.at(i)) continue;
            int n11 = n8 + n9 * this.v1l;
            this.Marked[n11] = this.Marked[n11] + d;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        this.qi.hide();
        int n3 = this.v[0].size();
        if (n3 > this.v[1].size()) {
            n3 = this.v[1].size();
        }
        String string = "n/a";
        String string2 = "n/a";
        if (Common.isQueryTrigger(mouseEvent)) {
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.v2l; ++i) {
                for (int j = 0; j < this.v1l; ++j) {
                    int n6 = this.A[0].getCatLow(j);
                    int n7 = this.A[1].getCatLow(i);
                    int n8 = this.A[0].getCatUp(j) - n6;
                    int n9 = this.A[1].getCatUp(i) - n7;
                    if (n8 < 0) {
                        n6 += n8;
                        n8 = -n8;
                    }
                    if (n9 < 0) {
                        n7 += n9;
                        n9 = -n9;
                    }
                    if (n >= n6 + n8 || n <= n6 || n2 >= n7 + n9 || n2 <= n7) continue;
                    string = (String)this.v[0].getCatAt(j);
                    string2 = (String)this.v[1].getCatAt(i);
                    for (int k = 0; k < n3; ++k) {
                        int n10 = this.v[0].getCatIndex(k);
                        int n11 = this.v[1].getCatIndex(k);
                        if (n10 != j || n11 != i) continue;
                        if (this.m.at(k)) {
                            ++n5;
                        }
                        ++n4;
                    }
                }
            }
            Point point = this.getFrame().getLocation();
            Point point2 = this.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            return;
        }
        if (mouseEvent.isControlDown()) {
            bl = true;
        }
        if (!mouseEvent.isShiftDown()) {
            this.m.selectNone();
        }
        for (int i = 0; i < this.v2l; ++i) {
            for (int j = 0; j < this.v1l; ++j) {
                int n12 = this.A[0].getCatLow(j);
                int n13 = this.A[1].getCatLow(i);
                int n14 = this.A[0].getCatUp(j) - n12;
                int n15 = this.A[1].getCatUp(i) - n13;
                if (n14 < 0) {
                    n12 += n14;
                    n14 = -n14;
                }
                if (n15 < 0) {
                    n13 += n15;
                    n15 = -n15;
                }
                if (n >= n12 + n14 || n <= n12 || n2 >= n13 + n15 || n2 <= n13) continue;
                for (int k = 0; k < n3; ++k) {
                    int n16 = this.v[0].getCatIndex(k);
                    int n17 = this.v[1].getCatIndex(k);
                    if (n16 != j || n17 != i) continue;
                    this.m.set(k, this.m.at(k) ? bl : true);
                }
            }
        }
        this.drag = false;
        this.m.NotifyAll(new NotifyMsg(this.m, 4096));
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.x1 = mouseEvent.getX();
        int n2 = this.y1 = mouseEvent.getY();
        this.qi.hide();
        if (n < this.X || n2 > this.Y + this.H) {
            if (n < this.X) {
                for (int i = 0; i < this.v2l; ++i) {
                    int n3;
                    int n4 = this.A[1].getCatLow(i);
                    if (n4 > (n3 = this.A[1].getCatUp(i))) {
                        int n5 = n4;
                        n4 = n3;
                        n3 = n5;
                    }
                    if (n2 <= n4 || n2 >= n3) continue;
                    this.setCursor(new Cursor(12));
                    this.mvY = true;
                    this.mvYstart = i;
                    return;
                }
            } else {
                for (int i = 0; i < this.v1l; ++i) {
                    int n6;
                    int n7 = this.A[0].getCatLow(i);
                    if (n7 > (n6 = this.A[0].getCatUp(i))) {
                        int n8 = n7;
                        n7 = n6;
                        n6 = n8;
                    }
                    if (n <= n7 || n >= n6) continue;
                    this.setCursor(new Cursor(12));
                    this.mvX = true;
                    this.mvXstart = i;
                    return;
                }
            }
        } else {
            this.drag = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getX() == this.x1 && mouseEvent.getY() == this.y1) {
            return;
        }
        if (this.mvX || this.mvY) {
            this.mvX = false;
            this.mvY = false;
            this.setUpdateRoot(0);
            this.setCursor(new Cursor(0));
            this.repaint();
        } else {
            int n;
            int n2 = this.x1;
            int n3 = this.y1;
            int n4 = this.x2;
            int n5 = this.y2;
            if (this.x1 > this.x2) {
                n4 = this.x1;
                n2 = this.x2;
            }
            if (this.y1 > this.y2) {
                n5 = this.y1;
                n3 = this.y2;
            }
            Rectangle rectangle = new Rectangle(n2, n3, n4 - n2, n5 - n3);
            this.drag = false;
            if (Common.isQueryTrigger(mouseEvent)) {
                return;
            }
            boolean bl = false;
            if (mouseEvent.isControlDown()) {
                bl = true;
            }
            if (!mouseEvent.isShiftDown()) {
                this.m.selectNone();
            }
            if ((n = this.v[0].size()) > this.v[1].size()) {
                n = this.v[1].size();
            }
            for (int i = 0; i < this.v2l; ++i) {
                for (int j = 0; j < this.v1l; ++j) {
                    int n6 = this.A[0].getCatLow(j);
                    int n7 = this.A[1].getCatLow(i);
                    int n8 = this.A[0].getCatUp(j) - n6;
                    int n9 = this.A[1].getCatUp(i) - n7;
                    if (n8 < 0) {
                        n6 += n8;
                        n8 = -n8;
                    }
                    if (n9 < 0) {
                        n7 += n9;
                        n9 = -n9;
                    }
                    if (n2 >= n6 + n8 || n4 <= n6 || n3 >= n7 + n9 || n5 <= n7) continue;
                    for (int k = 0; k < n; ++k) {
                        int n10 = this.v[0].getCatIndex(k);
                        int n11 = this.v[1].getCatIndex(k);
                        if (n10 != j || n11 != i) continue;
                        this.m.set(k, this.m.at(k) ? bl : true);
                    }
                }
            }
            this.m.NotifyAll(new NotifyMsg(this.m, 4096));
            this.setUpdateRoot(0);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.drag) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            if (n2 != this.x2 || n != this.y2) {
                this.x2 = n2;
                this.y2 = n;
                this.setUpdateRoot(1);
                this.repaint();
            }
        }
        if (this.mvX) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            this.dragNew = this.A[0].getCatByPos(n2);
            this.setUpdateRoot(1);
            if (this.dragNew != this.mvXstart) {
                this.A[0].moveCat(this.mvXstart, this.A[0].getCatSeqIndex(this.dragNew));
                this.setUpdateRoot(0);
            }
            this.repaint();
        }
        if (this.mvY) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            this.dragNew = this.A[1].getCatByPos(n);
            this.setUpdateRoot(1);
            if (this.dragNew != this.mvYstart) {
                this.A[1].moveCat(this.mvYstart, this.A[1].getCatSeqIndex(this.dragNew));
                this.setUpdateRoot(0);
            }
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'l') {
            this.run(this, "labels");
        }
        if (keyEvent.getKeyChar() == 'P') {
            this.run(this, "print");
        }
        if (keyEvent.getKeyChar() == 'X') {
            this.run(this, "exportPGS");
        }
        if (keyEvent.getKeyChar() == 'C') {
            this.run(this, "exportCases");
        }
        if (keyEvent.getKeyChar() == 'c') {
            this.run(this, "center");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Object run(Object object, String string) {
        super.run(object, string);
        if (this.m != null) {
            this.m.run(object, string);
        }
        if (string == "rotate") {
            this.rotate();
        }
        if (string == "labels") {
            this.showLabels = !this.showLabels;
            this.MIlabels.setLabel(this.showLabels ? "Hide labels" : "Show labels");
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "center") {
            this.centered = !this.centered;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "print") {
            this.run(object, "exportPS");
        }
        if (string == "exit") {
            WinTracker.current.Exit();
        }
        if (string == "exportCases") {
            try {
                PrintStream printStream = Tools.getNewOutputStreamDlg(this.myFrame, "Export selected cases to ...", "selected.txt");
                if (printStream != null) {
                    printStream.println(this.v[0].getName() + "\t" + this.v[1].getName());
                    int n = this.v[0].size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.m.at(i)) continue;
                        Object object2 = this.v[0].at(i);
                        printStream.println((object2 == null ? "NA" : object2.toString()) + "\t" + (this.v[1].at(i) == null ? "NA" : this.v[1].at(i).toString()));
                    }
                    printStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        this.run(actionEvent.getSource(), actionEvent.getActionCommand());
    }
}

